/*
 * Decompiled with CFR 0.152.
 */
package com.ezdml.httpsv;

import com.ezdml.model.ArrayMap;
import com.ezdml.model.CtMetaField;
import com.ezdml.model.CtMetaTable;
import com.ezdml.model.TypeUtil;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EzHttpServer {
    public static String sqlRsGetString(ResultSet rs, String col) {
        try {
            return rs.getString(col);
        }
        catch (SQLException e) {
            EzHttpServer.logMsg("Error getting col string value: " + col);
            e.printStackTrace();
            return null;
        }
    }

    public static String sqlRsGetString(ResultSet rs, int icol) {
        try {
            return rs.getString(icol);
        }
        catch (SQLException e) {
            EzHttpServer.logMsg("Error getting col string value: " + icol);
            e.printStackTrace();
            return null;
        }
    }

    public static int sqlRsGetInt(ResultSet rs, String col) {
        try {
            return rs.getInt(col);
        }
        catch (SQLException e) {
            EzHttpServer.logMsg("Error getting col int value: " + col);
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean sqlRsGetBoolean(ResultSet rs, String col) {
        try {
            return rs.getBoolean(col);
        }
        catch (SQLException e) {
            EzHttpServer.logMsg("Error getting col bool value: " + col);
            e.printStackTrace();
            return false;
        }
    }

    private static String valIfNull(String oldVal, String newVal) {
        if (oldVal != null && oldVal.length() > 0) {
            return oldVal;
        }
        return newVal;
    }

    private static String getDefConfigFile() {
        try {
            String path = EzHttpServer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (path.startsWith("file://")) {
                path = path.substring("file:/".length());
            } else if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            int iPos = path.lastIndexOf("/lib/");
            if (iPos == -1) {
                EzHttpServer.logMsg("Searching lib path failed: " + path);
                return null;
            }
            path = path.substring(0, iPos);
            File f = new File(path = path + File.separator + "jdbc.properties");
            if (f.exists()) {
                EzHttpServer.logMsg("Config file found: " + path);
                return path;
            }
            EzHttpServer.logMsg("Config file not found: " + path);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static void logMsg(String msg) {
        System.out.println(TypeUtil.getCurDateTimeStr() + " " + msg);
    }

    public static void main(String[] args) {
        Connection conn = null;
        try {
            EzHttpServer.logMsg("EzdmlJdbcHttpServer V20240926 by huzzz@163.com, launching...");
            String jdbcDriver = null;
            String jdbcUrl = null;
            String jdbcUser = null;
            String jdbcPwd = null;
            String httpPwd = null;
            String engTp = null;
            String config = null;
            int httpPort = 0;
            for (int i = 0; i < args.length; ++i) {
                String s = args[i];
                if (s == null) continue;
                if (s.startsWith("jdbc.config=")) {
                    config = s.substring("jdbc.config=".length());
                    continue;
                }
                if (s.startsWith("jdbc.driver=")) {
                    jdbcDriver = s.substring("jdbc.driver=".length());
                    continue;
                }
                if (s.startsWith("jdbc.url=")) {
                    jdbcUrl = s.substring("jdbc.url=".length());
                    continue;
                }
                if (s.startsWith("jdbc.username=")) {
                    jdbcUser = s.substring("jdbc.username=".length());
                    continue;
                }
                if (s.startsWith("jdbc.password=")) {
                    jdbcPwd = s.substring("jdbc.password=".length());
                    continue;
                }
                if (s.startsWith("jdbc.engineType=")) {
                    engTp = s.substring("jdbc.engineType=".length());
                    if (engTp == null || engTp.trim().length() != 0) continue;
                    engTp = null;
                    continue;
                }
                if (s.startsWith("http.password=")) {
                    httpPwd = s.substring("http.password=".length());
                    if (httpPwd == null || httpPwd.trim().length() != 0) continue;
                    httpPwd = null;
                    continue;
                }
                if (!s.startsWith("http.port=")) continue;
                s = s.substring("http.port=".length());
                httpPort = TypeUtil.ObjectToIntDef(s, httpPort);
            }
            if (config == null) {
                config = EzHttpServer.getDefConfigFile();
            }
            if (config != null && config.length() > 0) {
                EzHttpServer.logMsg("Loading config file... " + config);
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(config));
                Properties properties = new Properties();
                properties.load(inputStream);
                jdbcDriver = EzHttpServer.valIfNull(jdbcDriver, properties.getProperty("jdbc.driver"));
                jdbcUrl = EzHttpServer.valIfNull(jdbcUrl, properties.getProperty("jdbc.url"));
                jdbcUser = EzHttpServer.valIfNull(jdbcUser, properties.getProperty("jdbc.username"));
                jdbcPwd = EzHttpServer.valIfNull(jdbcPwd, properties.getProperty("jdbc.password"));
                engTp = EzHttpServer.valIfNull(engTp, properties.getProperty("jdbc.engineType"));
                httpPwd = EzHttpServer.valIfNull(httpPwd, properties.getProperty("http.password"));
                if (httpPort == 0) {
                    httpPort = TypeUtil.ObjectToIntDef(properties.getProperty("http.port"), 0);
                }
            }
            if (engTp == null && jdbcUrl != null) {
                String s = jdbcUrl.toLowerCase();
                if (s.contains("oracle")) {
                    engTp = "ORACLE";
                } else if (s.contains("mysql")) {
                    engTp = "MYSQL";
                } else if (s.contains("sqlserver")) {
                    engTp = "SQLSERVER";
                } else if (s.contains("sqlite")) {
                    engTp = "SQLITE";
                } else if (s.contains("jdbc:h2:")) {
                    engTp = "H2";
                } else if (s.contains("postgresql")) {
                    engTp = "POSTGRESQL";
                } else if (s.contains("hive")) {
                    engTp = "HIVE";
                }
            }
            if (httpPort <= 0 || jdbcDriver == null || jdbcUrl == null || jdbcUser == null || jdbcPwd == null || engTp == null) {
                EzHttpServer.logMsg("Error! config or parameters needed: jdbc.config=D:/EZDML_win64/jdbc/jdbc.properties jdbc.driver=oracle.jdbc.OracleDriver jdbc.url=jdbc:oracle:thin:@192.168.1.15:1521:ORCL jdbc.username=scott jdbc.password=1234 http.port=8083 http.password=abcd jdbc.engineType=ORACLE");
                return;
            }
            EzHttpServer.logMsg("Loading driver class... " + jdbcDriver);
            Class.forName(jdbcDriver);
            EzHttpServer.logMsg("Connecting database... " + jdbcUser + "/" + jdbcUrl);
            Properties props = new Properties();
            props.put("remarksReporting", "true");
            props.put("user", jdbcUser);
            props.put("password", jdbcPwd);
            conn = DriverManager.getConnection(jdbcUrl, props);
            EzHttpServer.logMsg("Connect database success.");
            EzHttpServer.logMsg("EzdmlJdbcHttpServer starting... binding port: " + httpPort + " engineType: " + engTp);
            HttpServer server = HttpServer.create(new InetSocketAddress(httpPort), 0);
            server.createContext("/ezdml/", new CtMetaHandler(server, conn, httpPwd, engTp));
            server.setExecutor(null);
            server.start();
            EzHttpServer.logMsg("EzdmlJdbcHttpServer started at http://localhost:" + httpPort + "/ezdml/" + (httpPwd == null ? " (NO PASSWORD AUTH!!!)" : " (PASSWORD AUTH ENABLED)"));
        }
        catch (Exception e) {
            EzHttpServer.logMsg("Failed with error: " + e.getMessage());
            e.printStackTrace();
            if (conn != null) {
                try {
                    EzHttpServer.logMsg("Closing database connection...");
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            EzHttpServer.logMsg("Exiting...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class CtMetaHandler
    implements HttpHandler {
        private HttpServer server;
        private String accessToken = null;
        private String delayCmd = null;
        private Connection dbconn;
        private String authPassword;
        private int errorPwdCounter = 0;
        private String engineType = "STANDARD";
        private Map<String, ResultSet> resultSetMap = new HashMap<String, ResultSet>();
        private Map<String, CallableStatement> statementMap = new HashMap<String, CallableStatement>();
        private static String[] CtDataTypeNames = new String[]{"Unknow", "String", "Integer", "Float", "Date", "Bool", "Enum", "Blob", "Object", "Calculate", "List", "Function", "Event", "Other"};

        public CtMetaHandler(HttpServer server, Connection conn, String httpPwd, String engTp) {
            this.server = server;
            this.dbconn = conn;
            this.authPassword = httpPwd;
            if (this.authPassword != null && this.authPassword.length() == 0) {
                this.authPassword = null;
            }
            this.engineType = engTp;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String param = httpExchange.getRequestURI().getQuery();
            if (param == null) {
                param = "(No param)";
            }
            String pth = httpExchange.getRequestURI().getPath();
            String ua = httpExchange.getRequestHeaders().getFirst("User-Agent");
            String tm = TypeUtil.getCurDateTimeStr();
            String vlog = httpExchange.getRequestMethod() + " " + pth + "?" + param + " " + ua;
            EzHttpServer.logMsg(vlog);
            ArrayMap<String, Object> res = new ArrayMap<String, Object>();
            res.put("resultCode", 0);
            res.put("time", tm);
            try {
                this.handelEzdmlReq(res, param, httpExchange);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                res.put("resultCode", -1);
                res.put("errorMsg", re.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                res.put("resultCode", -1);
                res.put("errorMsg", e.getMessage());
            }
            String cont = TypeUtil.mapToJsonStr(res);
            byte[] bs = cont.getBytes("UTF-8");
            httpExchange.getResponseHeaders().add("Content-Type", "text/plain; charset=UTF-8");
            httpExchange.sendResponseHeaders(200, bs.length);
            OutputStream os = httpExchange.getResponseBody();
            os.write(bs);
            os.close();
            int len = cont.length();
            vlog = len < 1024 ? cont : cont.substring(0, 1020) + "...";
            EzHttpServer.logMsg("RES (" + bs.length + " bytes)" + vlog);
            if ("stopServer".equals(this.delayCmd) && this.server != null) {
                HttpServer svr = this.server;
                this.server = null;
                EzHttpServer.logMsg("EzdmlJdbcHttpServer stopping...");
                this.clearCallCaches();
                svr.stop(2);
                try {
                    EzHttpServer.logMsg("Closing database connection...");
                    this.dbconn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.dbconn = null;
                EzHttpServer.logMsg("EzdmlJdbcHttpServer stopped.");
            }
        }

        private void clearCallCaches() {
            try {
                for (String k : this.resultSetMap.keySet()) {
                    ResultSet rs = this.resultSetMap.get(k);
                    CallableStatement st = this.statementMap.get(k);
                    if (rs != null) {
                        rs.close();
                    }
                    if (st == null) continue;
                    st.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.resultSetMap.clear();
            this.statementMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void handelEzdmlReq(Map<String, Object> res, String param, HttpExchange httpExchange) throws Exception {
            ResultSet rs;
            String cmd;
            if (this.dbconn == null) {
                throw new RuntimeException("database not ready");
            }
            String[] paramsp = param.split("&");
            HashMap<String, String> pmap = new HashMap<String, String>();
            for (String string : paramsp) {
                int po = string.indexOf("=");
                if (po <= 0) continue;
                pmap.put(string.substring(0, po), string.substring(po + 1));
            }
            if ("POST".equalsIgnoreCase(httpExchange.getRequestMethod())) {
                String sBody = null;
                InputStream inputStream = null;
                try {
                    int a;
                    inputStream = httpExchange.getRequestBody();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((a = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, a);
                    }
                    sBody = byteArrayOutputStream.toString("UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                paramsp = sBody.split("&");
                String pLog = "post params:";
                for (String par : paramsp) {
                    int po = par.indexOf("=");
                    if (po <= 0) continue;
                    String pname = par.substring(0, po);
                    String pvalue = TypeUtil.urlDecode(par.substring(po + 1));
                    pmap.put(pname, pvalue);
                    pLog = pLog + "\n  " + pname + "=";
                    pLog = pvalue.length() > 512 ? pLog + pvalue.substring(0, 500) + "..." : pLog + pvalue;
                }
                EzHttpServer.logMsg(pLog);
            }
            if ((cmd = (String)pmap.get("cmd")) == null || cmd.length() == 0) {
                throw new RuntimeException("cmd not assigned");
            }
            String eztoken = (String)pmap.get("eztoken");
            if (eztoken == null) {
                eztoken = "";
            }
            String param1 = (String)pmap.get("param1");
            String string = (String)pmap.get("param2");
            String data = (String)pmap.get("data");
            if ("nop".equals(cmd)) {
                res.put("RESULT", "NOP");
                return;
            }
            if ("connect".equals(cmd)) {
                if (this.authPassword != null) {
                    if (this.accessToken != null) {
                        throw new RuntimeException("already connected by aother client");
                    }
                    if (this.errorPwdCounter > 5) {
                        throw new RuntimeException("too many errors");
                    }
                    if (string == null || string.length() == 0) {
                        throw new RuntimeException("password needed");
                    }
                    if (!this.authPassword.equals(string)) {
                        ++this.errorPwdCounter;
                        throw new RuntimeException("invalid password");
                    }
                }
                this.errorPwdCounter = 0;
                this.accessToken = TypeUtil.genCtGuid().toLowerCase();
                res.put("EzdmlToken", this.accessToken);
                res.put("EngineType", this.engineType);
                try {
                    DatabaseMetaData meta = this.dbconn.getMetaData();
                    String DbSchema = meta.getUserName();
                    res.put("DbSchema", DbSchema);
                }
                catch (Throwable cme) {
                    EzHttpServer.logMsg("Error getting current user name: " + cme.getMessage());
                    cme.printStackTrace();
                }
                EzHttpServer.logMsg("client connected: " + httpExchange.getRemoteAddress() + " token:" + this.accessToken);
                return;
            }
            if (cmd.equals("stop")) {
                if (this.authPassword != null) {
                    if (this.errorPwdCounter > 5) {
                        throw new RuntimeException("too many errors");
                    }
                    if (!this.authPassword.equals(string)) {
                        ++this.errorPwdCounter;
                        throw new RuntimeException("invalid password");
                    }
                }
                this.clearCallCaches();
                this.delayCmd = "stopServer";
                res.put("RESULT", "OK");
                res.put("msg", "server stopping");
                return;
            }
            this.checkLogon(eztoken);
            if ("disconnect".equals(cmd)) {
                this.accessToken = null;
                this.clearCallCaches();
                return;
            }
            if ("ExecSql".equals(cmd)) {
                PreparedStatement stm = this.dbconn.prepareStatement(param1);
                if (!stm.execute()) {
                    res.put("RESULT", "OK");
                } else {
                    res.put("RESULT", "SQL returns a result-set");
                }
                return;
            }
            if ("OpenTable".equals(cmd)) {
                PreparedStatement stm = this.dbconn.prepareStatement(param1);
                rs = stm.executeQuery();
                ResultSetMetaData md = rs.getMetaData();
                List<Map<String, Object>> cols = this.getResultSetMetaCols(md);
                res.put("Cols", cols);
                res.put("TableName", md.getTableName(1));
                res.put("CatalogName", md.getCatalogName(1));
                List<Map<String, Object>> ds = CtMetaHandler.convertResultSetToList(rs, 0);
                res.put("Rows", ds);
                return;
            }
            if ("GetDbUsers".equals(cmd)) {
                DatabaseMetaData meta = this.dbconn.getMetaData();
                rs = meta.getSchemas();
                ArrayList<String> ds = new ArrayList<String>();
                while (rs.next()) {
                    String tableSchem = EzHttpServer.sqlRsGetString(rs, "TABLE_SCHEM");
                    ds.add(tableSchem);
                }
                rs.close();
                res.put("itemList", ds);
                return;
            }
            if ("GetDbObjs".equals(cmd)) {
                if (param1 != null && param1.length() == 0) {
                    param1 = null;
                }
                DatabaseMetaData meta = this.dbconn.getMetaData();
                String[] types = new String[]{"TABLE"};
                ResultSet rs2 = meta.getTables(null, param1, null, types);
                ArrayList<String> ds = new ArrayList<String>();
                while (rs2.next()) {
                    String tableSchem = EzHttpServer.sqlRsGetString(rs2, "TABLE_SCHEM");
                    String tableName = EzHttpServer.sqlRsGetString(rs2, "TABLE_NAME");
                    if (!(tableSchem == null || tableSchem.length() <= 0 || param1 != null && param1.equalsIgnoreCase(tableSchem))) {
                        ds.add(tableSchem + "." + tableName);
                        continue;
                    }
                    ds.add(tableName);
                }
                rs2.close();
                res.put("itemList", ds);
                return;
            }
            if ("GetObjInfos".equals(cmd)) {
                String[] types;
                ResultSet rs3;
                if (param1 != null && param1.length() == 0) {
                    param1 = null;
                }
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("table name not assigned");
                }
                DatabaseMetaData meta = this.dbconn.getMetaData();
                boolean dbTypeName = false;
                if (data != null && data.contains("[DBTYPENAMES]")) {
                    dbTypeName = true;
                }
                if (!(rs3 = meta.getTables(null, param1, string, types = new String[]{"TABLE"})).next()) {
                    throw new RuntimeException("table not found - " + (param1 == null ? "" : param1 + ".") + string);
                }
                String tableName = EzHttpServer.sqlRsGetString(rs3, "TABLE_NAME");
                String tableRemark = EzHttpServer.sqlRsGetString(rs3, "REMARKS");
                if (rs3.next()) {
                    if (param1 == null && data != null && data.contains("[SKIP_MULTI_ERROR]")) {
                        param1 = EzHttpServer.sqlRsGetString(rs3, "TABLE_SCHEM");
                    } else {
                        throw new RuntimeException("too many tables found - " + (param1 == null ? "" : param1 + ".") + string);
                    }
                }
                rs3.close();
                CtMetaTable tb = new CtMetaTable();
                tb.setName(tableName);
                tb.setMemo(tableRemark);
                rs3 = meta.getColumns(null, param1, string, null);
                while (rs3.next()) {
                    CtMetaField fd = tb.newField();
                    fd.setName(EzHttpServer.sqlRsGetString(rs3, "COLUMN_NAME"));
                    int colTp = EzHttpServer.sqlRsGetInt(rs3, "DATA_TYPE");
                    String tpName = EzHttpServer.sqlRsGetString(rs3, "TYPE_NAME");
                    int colSz = EzHttpServer.sqlRsGetInt(rs3, "COLUMN_SIZE");
                    int colDig = EzHttpServer.sqlRsGetInt(rs3, "DECIMAL_DIGITS");
                    if ((colTp == 2 || colTp == 3) && colDig == 0) {
                        colTp = 4;
                    }
                    int cTp = this.getCtDataType(colTp);
                    fd.setDataType(cTp);
                    if (dbTypeName || cTp >= 8) {
                        fd.setDataTypeName(tpName);
                    }
                    if (cTp != 2 && cTp != 4 && cTp != 7) {
                        fd.setDataLength(colSz);
                        fd.setDataScale(colDig);
                    }
                    int iNullable = EzHttpServer.sqlRsGetInt(rs3, "NULLABLE");
                    fd.setMemo(EzHttpServer.sqlRsGetString(rs3, "REMARKS"));
                    fd.setDefaultValue(EzHttpServer.sqlRsGetString(rs3, "COLUMN_DEF"));
                    fd.setOrderNo(EzHttpServer.sqlRsGetInt(rs3, "ORDINAL_POSITION"));
                    String sIsNullable = EzHttpServer.sqlRsGetString(rs3, "IS_NULLABLE");
                    if (iNullable == 0 || "NO".equals(sIsNullable)) {
                        fd.setNullable(false);
                    } else {
                        fd.setNullable(true);
                    }
                    if ("HIVE".equalsIgnoreCase(this.engineType) || !"YES".equals(EzHttpServer.sqlRsGetString(rs3, "IS_AUTOINCREMENT")) || fd.getDefaultValue() != null && fd.getDefaultValue().length() != 0) continue;
                    fd.setDefaultValue("{auto_increment}");
                }
                rs3.close();
                rs3 = meta.getPrimaryKeys(null, param1, string);
                while (rs3.next()) {
                    CtMetaField fd;
                    String col = EzHttpServer.sqlRsGetString(rs3, "COLUMN_NAME");
                    if (col == null || col.length() <= 0 || (fd = tb.fieldByName(col)) == null) continue;
                    fd.setKeyFieldType(1);
                }
                rs3.close();
                rs3 = meta.getIndexInfo(null, param1, string, false, false);
                while (rs3.next()) {
                    CtMetaField fd;
                    boolean nonUnique = EzHttpServer.sqlRsGetBoolean(rs3, "NON_UNIQUE");
                    String col = EzHttpServer.sqlRsGetString(rs3, "COLUMN_NAME");
                    if (col == null || col.length() <= 0 || (fd = tb.fieldByName(col)) == null) continue;
                    if (nonUnique) {
                        fd.setIndexType(2);
                        continue;
                    }
                    if (fd.getKeyFieldType() == 1) continue;
                    fd.setIndexType(1);
                }
                rs3.close();
                rs3 = meta.getImportedKeys(null, param1, string);
                while (rs3.next()) {
                    CtMetaField fd;
                    String rtb = EzHttpServer.sqlRsGetString(rs3, "PKTABLE_NAME");
                    String rcol = EzHttpServer.sqlRsGetString(rs3, "PKCOLUMN_NAME");
                    String col = EzHttpServer.sqlRsGetString(rs3, "FKCOLUMN_NAME");
                    if (col == null || col.length() <= 0 || (fd = tb.fieldByName(col)) == null || fd.getKeyFieldType() == 1) continue;
                    fd.setKeyFieldType(3);
                    fd.setRelateTable(rtb);
                    fd.setRelateField(rcol);
                }
                rs3.close();
                tb.saveToMap(res);
                return;
            }
            if ("ObjectExists".equals(cmd)) {
                if (param1 != null && param1.length() == 0) {
                    param1 = null;
                }
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("object name not assigned");
                }
                DatabaseMetaData meta = this.dbconn.getMetaData();
                rs = meta.getTables(null, param1, string, null);
                boolean bFound = false;
                if (rs.next()) {
                    bFound = true;
                }
                rs.close();
                res.put("RESULT", bFound ? "true" : "false");
                return;
            }
            if ("GenCustomSql".equals(cmd)) {
                if (param1 == null || param1.length() == 0) {
                    throw new RuntimeException("table1 not assigned");
                }
                if (string != null && string.length() == 0) {
                    Object var9_22 = null;
                }
                if (data == null || data.length() == 0) {
                    throw new RuntimeException("option data not assigned");
                }
                Map<String, Object> optmap = TypeUtil.jsonStrToMap(data);
                if (optmap == null) {
                    throw new RuntimeException("option data map invalid");
                }
                String defRes = TypeUtil.ObjToStr(optmap.get("DefaultResult"));
                res.put("RESULT", "/* gen by http server " + TypeUtil.getCurDateTimeStr() + " */\r\n" + defRes);
                return;
            }
            if ("SqlCall_Open".equals(cmd)) {
                void var9_24;
                if (param1 == null || param1.length() == 0) {
                    throw new RuntimeException("sql not assigned");
                }
                if (string != null && string.trim().length() == 0) {
                    Object var9_23 = null;
                }
                Map<String, Object> paraMap = null;
                if (var9_24 != null) {
                    paraMap = TypeUtil.jsonStrToMap((String)var9_24);
                }
                if (paraMap == null) {
                    paraMap = new HashMap<String, Object>();
                }
                String callType = TypeUtil.ObjToStrNotNull(paraMap.get("callType")).trim().toLowerCase();
                String jSql = this.parseSqlParamNames(param1, paraMap);
                CallableStatement ctstm = this.dbconn.prepareCall(jSql);
                this.setSqlCallParams(ctstm, paraMap);
                ResultSet rs4 = null;
                int updateCount = 0;
                if (callType.equals("update")) {
                    updateCount = ctstm.executeUpdate();
                    this.getSqlCallParams(ctstm, paraMap);
                    res.put("updateCount", updateCount);
                    res.put("SqlParams", paraMap.get("SqlParams"));
                    ctstm.close();
                } else if (callType.equals("query")) {
                    rs4 = ctstm.executeQuery();
                    this.getSqlCallParams(ctstm, paraMap);
                    this.fetchRecords(rs4, paraMap, true);
                    rs4.close();
                    ctstm.close();
                    res.put("dataList", paraMap.get("dataList"));
                    res.put("dataEof", paraMap.get("dataEof"));
                    res.put("dataCols", paraMap.get("dataCols"));
                } else if (callType.equals("cursor")) {
                    rs4 = ctstm.executeQuery();
                    this.getSqlCallParams(ctstm, paraMap);
                    this.fetchRecords(rs4, paraMap, true);
                    String callGuid = TypeUtil.ObjToStrNotNull(paraMap.get("callGuid"));
                    if (callGuid == null || callGuid.trim().length() == 0) {
                        callGuid = TypeUtil.genCtGuid();
                        res.put("callGuid", callGuid);
                    }
                    res.put("dataList", paraMap.get("dataList"));
                    res.put("dataEof", paraMap.get("dataEof"));
                    res.put("dataCols", paraMap.get("dataCols"));
                    if (TypeUtil.ObjectToBool(paraMap.get("dataEof"))) {
                        rs4.close();
                        ctstm.close();
                        this.resultSetMap.put(callGuid, null);
                        this.statementMap.put(callGuid, null);
                    } else {
                        this.resultSetMap.put(callGuid, rs4);
                        this.statementMap.put(callGuid, ctstm);
                    }
                } else {
                    if (ctstm.execute()) {
                        this.getSqlCallParams(ctstm, paraMap);
                        rs4 = ctstm.getResultSet();
                        this.fetchRecords(rs4, paraMap, true);
                        res.put("dataList", paraMap.get("dataList"));
                        res.put("dataEof", paraMap.get("dataEof"));
                        res.put("dataCols", paraMap.get("dataCols"));
                        rs4.close();
                    } else {
                        this.getSqlCallParams(ctstm, paraMap);
                        updateCount = ctstm.getUpdateCount();
                        res.put("updateCount", updateCount);
                        res.put("SqlParams", paraMap.get("SqlParams"));
                    }
                    ctstm.close();
                }
                res.put("RESULT", "OK");
                return;
            }
            if ("SqlCall_Fetch".equals(cmd)) {
                if (param1 == null || param1.length() == 0) {
                    throw new RuntimeException("callGuid not assigned");
                }
                if (string != null && string.trim().length() == 0) {
                    Object var9_25 = null;
                }
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                String callGuid = param1;
                if (!this.resultSetMap.containsKey(callGuid)) {
                    throw new RuntimeException("cursor not found: " + callGuid);
                }
                ResultSet rs5 = this.resultSetMap.get(callGuid);
                if (rs5 != null) {
                    this.fetchRecords(rs5, paraMap, false);
                    res.put("dataList", paraMap.get("dataList"));
                    res.put("dataEof", paraMap.get("dataEof"));
                } else {
                    res.put("dataList", new ArrayList());
                    res.put("dataEof", true);
                }
                res.put("RESULT", "OK");
                return;
            }
            if ("SqlCall_Close".equals(cmd)) {
                if (param1 == null || param1.length() == 0) {
                    throw new RuntimeException("callGuid not assigned");
                }
                String callGuid = param1;
                if (!this.resultSetMap.containsKey(callGuid)) {
                    return;
                }
                if (!this.resultSetMap.containsKey(callGuid)) {
                    return;
                }
                rs = this.resultSetMap.get(callGuid);
                CallableStatement stm = this.statementMap.get(callGuid);
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                this.resultSetMap.remove(callGuid);
                this.statementMap.remove(callGuid);
                res.put("RESULT", "OK");
                return;
            }
            throw new RuntimeException("unsupported cmd - " + cmd);
        }

        private List<Map<String, Object>> getResultSetMetaCols(ResultSetMetaData md) throws SQLException {
            if (md == null) {
                return null;
            }
            int columnCount = md.getColumnCount();
            ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
            for (int i = 1; i <= columnCount; ++i) {
                ArrayMap<String, Object> col = new ArrayMap<String, Object>();
                String fName = CtMetaHandler.getColUniName(md, i);
                col.put("Name", fName);
                int idt = md.getColumnType(i);
                String tpName = md.getColumnTypeName(i);
                String dt = this.getColDataTypeName(idt, tpName);
                col.put("DataType", dt);
                col.put("DataTypeName", tpName);
                if ("String".equalsIgnoreCase(dt)) {
                    col.put("Size", md.getPrecision(i));
                }
                cols.add(col);
            }
            return cols;
        }

        private void fetchRecords(ResultSet rs, Map<String, Object> paraMap, boolean withCols) throws SQLException {
            int maxCount = TypeUtil.ObjectToIntDef(paraMap.get("maxFetchCount"), 200);
            if (maxCount <= 0) {
                maxCount = 200;
            }
            ArrayList<Map<String, Object>> ds = new ArrayList<Map<String, Object>>();
            ResultSetMetaData md = rs.getMetaData();
            int c = 0;
            boolean bEof = true;
            while (rs.next()) {
                Map<String, Object> rowData = CtMetaHandler.getRowDataMap(rs, md);
                ds.add(rowData);
                if (++c < maxCount) continue;
                bEof = false;
                break;
            }
            paraMap.put("dataList", ds);
            paraMap.put("dataEof", bEof);
            if (withCols) {
                List<Map<String, Object>> cols = this.getResultSetMetaCols(md);
                paraMap.put("dataCols", cols);
                paraMap.put("TableName", md.getTableName(1));
                paraMap.put("CatalogName", md.getCatalogName(1));
            }
        }

        private void getSqlCallParams(CallableStatement stm, Map<String, Object> paraMap) throws SQLException {
            if (paraMap == null) {
                return;
            }
            List<Map<String, Object>> sqlParams = TypeUtil.CastToList_SO(paraMap.get("SqlParamsJdbc"));
            if (sqlParams == null) {
                return;
            }
            for (int idx = 1; idx <= sqlParams.size(); ++idx) {
                Map<String, Object> par = sqlParams.get(idx - 1);
                if (par == null) continue;
                String tp = TypeUtil.ObjToStr(par.get("type"));
                String inout = TypeUtil.ObjToStrNotNull(par.get("inout")).trim().toLowerCase();
                if (tp == null || tp.trim().length() == 0) {
                    tp = "string";
                }
                tp = tp.trim().toLowerCase();
                if (!"out".equals(inout) && !"inout".equals(inout)) continue;
                if (tp.equals("date")) {
                    Timestamp tm = stm.getTimestamp(idx);
                    if (tm == null) {
                        par.put("value_out", null);
                        continue;
                    }
                    par.put("value_out", TypeUtil.formatDate(tm, null));
                    continue;
                }
                if (tp.equals("blob")) {
                    byte[] buf = stm.getBytes(idx);
                    par.put("value_out", buf);
                    continue;
                }
                par.put("value_out", stm.getObject(idx));
            }
        }

        private String parseSqlParamNames(String sql, Map<String, Object> paraMap) {
            if (paraMap == null) {
                return sql;
            }
            List<Map<String, Object>> sqlParams = TypeUtil.CastToList_SO(paraMap.get("SqlParams"));
            if (sqlParams == null) {
                return sql;
            }
            paraMap.put("SqlParamsJdbc", sqlParams);
            if (sql == null) {
                return sql;
            }
            if (sql.indexOf(63) >= 0) {
                return sql;
            }
            if (sql.indexOf(58) < 0) {
                return sql;
            }
            HashMap<String, Map<String, Object>> sqlParsMap = new HashMap<String, Map<String, Object>>();
            for (int idx = 0; idx < sqlParams.size(); ++idx) {
                String paramName;
                Map<String, Object> par = sqlParams.get(idx);
                if (par == null || (paramName = TypeUtil.ObjToStrNotNull(par.get("name"))).length() == 0) continue;
                sqlParsMap.put(paramName, par);
            }
            String regex = ":(([\\p{L}0-9_\\u4e00-\\u9fa5]+)|(\"[\\p{L}0-9_\\u4e00-\\u9fa5]+\")|('[\\p{L}0-9_\\u4e00-\\u9fa5]+'))";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sql);
            StringBuffer sb = new StringBuffer();
            ArrayList<Map<String, Object>> sqlParamsJdbc = new ArrayList<Map<String, Object>>();
            while (matcher.find()) {
                Map<String, Object> par;
                String paramName = matcher.group().substring(1);
                matcher.appendReplacement(sb, "?");
                if (paramName.startsWith("'") && paramName.endsWith("'") || paramName.startsWith("\"") && paramName.endsWith("\"")) {
                    paramName = paramName.substring(1, paramName.length() - 1);
                }
                if ((par = TypeUtil.CastToMap_SO(sqlParsMap.get(paramName))) == null) {
                    par = new HashMap<String, Object>();
                    par.put("name", paramName);
                    par.put("type", "String");
                }
                sqlParamsJdbc.add(par);
            }
            matcher.appendTail(sb);
            System.out.println("SQL reformed: " + sb.toString());
            String cont = ((Object)sqlParamsJdbc).toString();
            if (cont.length() > 1024) {
                cont = cont.substring(0, 1020) + "...";
            }
            System.out.println("JDBC Params: " + cont);
            paraMap.put("SqlParamsJdbc", sqlParamsJdbc);
            return sb.toString();
        }

        private void setSqlCallParams(CallableStatement stm, Map<String, Object> paraMap) throws SQLException {
            if (paraMap == null) {
                return;
            }
            List<Map<String, Object>> sqlParams = TypeUtil.CastToList_SO(paraMap.get("SqlParamsJdbc"));
            if (sqlParams == null) {
                return;
            }
            for (int idx = 1; idx <= sqlParams.size(); ++idx) {
                Map<String, Object> par = sqlParams.get(idx - 1);
                if (par == null) continue;
                String tp = TypeUtil.ObjToStr(par.get("type"));
                Object val = par.get("value");
                String inout = TypeUtil.ObjToStrNotNull(par.get("inout")).trim().toLowerCase();
                if (tp == null || tp.trim().length() == 0) {
                    tp = "string";
                }
                tp = tp.trim().toLowerCase();
                if (inout.length() == 0 || inout.equals("in") || inout.equals("inout")) {
                    if (val == null) {
                        stm.setNull(idx, this.getSqlDataTypeOfName(tp));
                    } else if (val instanceof String && "".equals(val)) {
                        stm.setNull(idx, this.getSqlDataTypeOfName(tp));
                    } else if (tp.equals("int")) {
                        stm.setInt(idx, TypeUtil.ObjToInt(val));
                    } else if (tp.equals("float")) {
                        stm.setDouble(idx, TypeUtil.ObjectToDouble(val));
                    } else if (tp.equals("date")) {
                        Date date = TypeUtil.ObjectToDate(val);
                        Timestamp tm = new Timestamp(date.getTime());
                        stm.setTimestamp(idx, tm);
                    } else if (tp.equals("blob")) {
                        String str = TypeUtil.ObjToStr(val);
                        byte[] buf = this.getBytesOfHexStr(str);
                        stm.setBytes(idx, buf);
                    } else if (tp.equals("bool")) {
                        stm.setBoolean(idx, TypeUtil.ObjectToBool(val));
                    } else {
                        stm.setString(idx, TypeUtil.ObjToStr(val));
                    }
                }
                if (!"out".equals(inout) && !"inout".equals(inout)) continue;
                stm.registerOutParameter(idx, this.getSqlDataTypeOfName(tp));
            }
        }

        private int getCtDataType(int columnType) {
            String stp = this.getColDataTypeName(columnType, null);
            for (int i = 0; i < CtDataTypeNames.length; ++i) {
                if (!CtDataTypeNames[i].contentEquals(stp)) continue;
                return i;
            }
            return 0;
        }

        private String getColDataTypeName(int columnType, String tpName) {
            String t;
            switch (columnType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return "Integer";
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return "Float";
                }
                case 91: 
                case 92: 
                case 93: 
                case 2013: 
                case 2014: {
                    return "Date";
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return "Blob";
                }
                case 16: {
                    return "Bool";
                }
                case 2000: 
                case 2001: 
                case 2002: 
                case 2009: {
                    return "Object";
                }
                case 2003: {
                    return "List";
                }
                case 70: 
                case 1111: 
                case 2006: 
                case 2012: {
                    return "Other";
                }
            }
            if (tpName != null && ((t = tpName.trim().toLowerCase()).contains("date") || t.contains("time"))) {
                return "Date";
            }
            return "String";
        }

        private int getSqlDataTypeOfName(String tName) {
            if (tName == null) {
                return 12;
            }
            if ((tName = tName.trim().toLowerCase()).equals("int")) {
                return 4;
            }
            if (tName.equals("float")) {
                return 8;
            }
            if (tName.equals("date")) {
                return 93;
            }
            if (tName.equals("blob")) {
                return 2004;
            }
            if (tName.equals("bool")) {
                return 16;
            }
            return 12;
        }

        private void checkLogon(String eztoken) {
            if (this.authPassword == null) {
                return;
            }
            if (eztoken.length() == 0) {
                throw new RuntimeException("logon-needed");
            }
            if (this.accessToken == null) {
                throw new RuntimeException("not-logged-on");
            }
            if (!eztoken.equals(this.accessToken)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                throw new RuntimeException("logon-invalid");
            }
        }

        public static List<Map<String, Object>> convertResultSetToList(ResultSet rs, int maxCount) throws SQLException {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ResultSetMetaData md = rs.getMetaData();
            int c = 0;
            while (rs.next()) {
                Map<String, Object> rowData = CtMetaHandler.getRowDataMap(rs, md);
                list.add(rowData);
                if (maxCount <= 0 || ++c < maxCount) continue;
                break;
            }
            return list;
        }

        protected static Map<String, Object> getRowDataMap(ResultSet rs, ResultSetMetaData md) throws SQLException {
            int columnCount = md.getColumnCount();
            ArrayMap<String, Object> rowData = new ArrayMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                int ctp = md.getColumnType(i);
                String cnm = CtMetaHandler.getColUniName(md, i);
                if (ctp == 2004 || ctp == -2 || ctp == -3 || ctp == -4) {
                    rowData.put(cnm, CtMetaHandler.getHexStr(rs.getBytes(i)));
                    continue;
                }
                if (ctp == 2005) {
                    rowData.put(cnm, EzHttpServer.sqlRsGetString(rs, i));
                    continue;
                }
                if (ctp == 91 || ctp == 92 || ctp == 93) {
                    Timestamp tm = rs.getTimestamp(i);
                    rowData.put(cnm, tm == null ? null : TypeUtil.formatDate(tm, null));
                    continue;
                }
                Object obj = rs.getObject(i);
                if (obj != null && obj instanceof Date) {
                    obj = TypeUtil.formatDate((Date)obj, null);
                }
                rowData.put(cnm, obj);
            }
            return rowData;
        }

        private static String getColUniName(ResultSetMetaData md, int idx) throws SQLException {
            String res = md.getColumnName(idx);
            if (res == null || res.trim().length() == 0) {
                res = "_F_UNNAMED_" + idx;
            }
            return res;
        }

        private static String getHexStr(byte[] byteArray) {
            if (byteArray == null) {
                return null;
            }
            StringBuffer hexString = new StringBuffer();
            String hex = null;
            for (int i = 0; i < byteArray.length; ++i) {
                hex = Integer.toHexString(0xFF & byteArray[i]);
                if (hex.length() == 1) {
                    hexString.append("0" + hex);
                    continue;
                }
                hexString.append(hex);
            }
            return hexString.toString().toUpperCase();
        }

        private byte[] getBytesOfHexStr(String str) {
            if (str == null) {
                return null;
            }
            byte[] res = new byte[str.length() / 2];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (byte)(0xFF & Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16));
            }
            return res;
        }
    }
}

