/*
 * Decompiled with CFR 0.152.
 */
package com.ezdml.model;

import com.ezdml.model.ArrayMap;
import com.ezdml.model.CtMetaField;
import com.ezdml.model.CtMetaTable;
import com.ezdml.model.TypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class AIHelper {
    private static String[] AiCtDataTypeNames = new String[]{"Unknow", "string", "integer", "float", "datetime", "boolean", "Enum", "binary", "Object", "Calculate", "List", "Function", "Event", "Other"};

    public static String extractJsonStr(String res) {
        if (res == null || res.trim().length() == 0) {
            return null;
        }
        res = res.trim();
        String[] ss = res.split("\n");
        StringBuilder sb = new StringBuilder();
        block0: for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            if (s.trim().equalsIgnoreCase("```json")) {
                for (int j = i + 1; j < ss.length; ++j) {
                    s = ss[j];
                    if (s.trim().equalsIgnoreCase("```")) {
                        res = sb.toString();
                        break block0;
                    }
                    sb.append(s + "\n");
                }
            } else {
                if (!s.trim().equalsIgnoreCase("'''json")) continue;
                for (int j = i + 1; j < ss.length; ++j) {
                    s = ss[j];
                    if (s.trim().equalsIgnoreCase("'''")) {
                        res = sb.toString();
                        break block0;
                    }
                    sb.append(s + "\n");
                }
            }
            break;
        }
        res = res.trim();
        return res;
    }

    public static List<CtMetaTable> loadAITables(String res) {
        if ((res = AIHelper.extractJsonStr(res)).length() == 0) {
            return null;
        }
        if (!res.startsWith("{")) {
            return null;
        }
        Map<String, Object> jMap = TypeUtil.jsonStrToMap(res);
        List<Map<String, Object>> jTbs = TypeUtil.CastToList_SO(jMap.get("tables"));
        if (jTbs == null || jTbs.size() == 0) {
            return null;
        }
        ArrayList<CtMetaTable> rs = new ArrayList<CtMetaTable>();
        for (int i = 0; i < jTbs.size(); ++i) {
            CtMetaTable mtb = new CtMetaTable();
            mtb.setId(i + 1);
            mtb.loadFromAIMap(jTbs.get(i));
            rs.add(mtb);
        }
        return rs;
    }

    public static List<CtMetaField> loadAIFields(String res) {
        if ((res = AIHelper.extractJsonStr(res)).length() == 0) {
            return null;
        }
        if (!res.startsWith("{")) {
            return null;
        }
        Map<String, Object> jMap = TypeUtil.jsonStrToMap(res);
        List<Map<String, Object>> jFds = TypeUtil.CastToList_SO(jMap.get("fields"));
        if (jFds == null || jFds.size() == 0) {
            jFds = TypeUtil.CastToList_SO(jMap.get("new-fields"));
        }
        if (jFds == null || jFds.size() == 0) {
            return null;
        }
        ArrayList<CtMetaField> rs = new ArrayList<CtMetaField>();
        for (int i = 0; i < jFds.size(); ++i) {
            CtMetaField mfd = new CtMetaField();
            mfd.setId(i + 1);
            mfd.loadFromAIMap(jFds.get(i));
            rs.add(mfd);
        }
        if (jMap.get("table-cn-name") != null) {
            String enName = TypeUtil.ObjToStr(jMap.get("table-en-name"));
            String cnName = TypeUtil.ObjToStr(jMap.get("table-cn-name"));
            if (enName == null) {
                enName = cnName;
            }
            CtMetaField mfd = new CtMetaField();
            mfd.setName(enName);
            mfd.setDisplayName(cnName);
            rs.add(mfd);
        }
        return rs;
    }

    private static int getCtDataType(String tpName) {
        for (int i = 0; i < AiCtDataTypeNames.length; ++i) {
            if (!AiCtDataTypeNames[i].contentEquals(tpName)) continue;
            return i;
        }
        return 0;
    }

    public static CtMetaTable findTableByName(List<CtMetaTable> tbs, String name) {
        for (CtMetaTable tb : tbs) {
            if (tb.getName() == null || !tb.getName().equalsIgnoreCase(name)) continue;
            return tb;
        }
        return null;
    }

    public static int checkAITableFields(List<CtMetaTable> tbs) {
        int c = 0;
        for (CtMetaTable tb : tbs) {
            List<CtMetaField> fs = tb.getMetaFields();
            for (CtMetaField f : fs) {
                CtMetaTable mtb;
                int tpi;
                String tpN;
                if (f.getDataType() == 0 && (tpN = f.getDataTypeName()) != null && tpN.trim().length() > 0 && (tpi = AIHelper.getCtDataType(tpN)) > 0) {
                    f.setDataType(tpi);
                    f.setDataTypeName(null);
                }
                if (f.getKeyFieldType() != 1 && f.getKeyFieldType() != 3 || f.relateTable == null || f.relateTable.trim().length() <= 0 || f.relateField != null && f.relateField.trim().length() != 0 || (mtb = AIHelper.findTableByName(tbs, f.relateTable)) == null) continue;
                f.relateField = mtb.getPkFieldName();
                if (f.relateField == null || f.relateField.trim().length() <= 0) continue;
                ++c;
            }
        }
        return c;
    }

    public static int checkAIFieldList(List<CtMetaField> fs) {
        int c = 0;
        for (CtMetaField f : fs) {
            int tpi;
            String tpN;
            if (f.getDataType() != 0 || (tpN = f.getDataTypeName()) == null || tpN.trim().length() <= 0 || (tpi = AIHelper.getCtDataType(tpN)) <= 0) continue;
            f.setDataType(tpi);
            f.setDataTypeName(null);
        }
        return c;
    }

    public static List<Map<String, Object>> AITableRes2EzJson(String res) {
        List<CtMetaTable> tbs = AIHelper.loadAITables(res);
        if (tbs == null) {
            return null;
        }
        AIHelper.checkAITableFields(tbs);
        ArrayList<Map<String, Object>> rs = new ArrayList<Map<String, Object>>();
        for (CtMetaTable tb : tbs) {
            ArrayMap<String, Object> m = new ArrayMap<String, Object>();
            tb.saveToMap(m);
            rs.add(m);
        }
        return rs;
    }

    public static List<Map<String, Object>> AIFieldRes2EzJson(String res) {
        List<CtMetaField> fds = AIHelper.loadAIFields(res);
        if (fds == null) {
            return null;
        }
        AIHelper.checkAIFieldList(fds);
        ArrayList<Map<String, Object>> rs = new ArrayList<Map<String, Object>>();
        for (CtMetaField fd : fds) {
            ArrayMap<String, Object> m = new ArrayMap<String, Object>();
            fd.saveToMap(m);
            rs.add(m);
        }
        return rs;
    }

    public static void main1(String[] args) {
        String res = "xxx\nfff\n```json\n{\n \"tables\": [\n   {\n     \"name\": \"EZ_Product\",\n     \"cn-name\": \"\u4ea7\u54c1\u8868\",\n     \"comment\": \"\u5b58\u50a8\u6240\u6709\u4ea7\u54c1\u7684\u76f8\u5173\u4fe1\u606f\",\n     \"referenced-by\": \"EZ_ORDER,EZ_PRDINFO,EZ_KKRTEST\",\n     \"fields\": [\n       {\n         \"name\": \"product_id\",\n         \"cn-name\": \"\u4ea7\u54c1ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"true\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u552f\u4e00\u6807\u8bc6\u6bcf\u4e2a\u4ea7\u54c1\u7684ID\"\n       },\n       {\n         \"name\": \"product_name\",\n         \"cn-name\": \"\u4ea7\u54c1\u540d\u79f0\",\n         \"data-type\": \"string\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u4ea7\u54c1\u7684\u540d\u79f0\"\n       },\n       {\n         \"name\": \"create_time\",\n         \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n         \"data-type\": \"datetime\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8bb0\u5f55\u4ea7\u54c1\u521b\u5efa\u7684\u65f6\u95f4\"\n       }\n     ]\n   },\n   {\n     \"name\": \"EZ_Supplier\",\n     \"cn-name\": \"\u4f9b\u5e94\u5546\u8868\",\n     \"comment\": \"\u5b58\u50a8\u6240\u6709\u4f9b\u5e94\u5546\u7684\u76f8\u5173\u4fe1\u606f\",\n     \"fields\": [\n       {\n         \"name\": \"supplier_id\",\n         \"cn-name\": \"\u4f9b\u5e94\u5546ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"true\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u552f\u4e00\u6807\u8bc6\u6bcf\u4e2a\u4f9b\u5e94\u5546\u7684ID\"\n       },\n       {\n         \"name\": \"supplier_name\",\n         \"cn-name\": \"\u4f9b\u5e94\u5546\u540d\u79f0\",\n         \"data-type\": \"string\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u4f9b\u5e94\u5546\u7684\u540d\u79f0\"\n       },\n       {\n         \"name\": \"create_time\",\n         \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n         \"data-type\": \"datetime\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8bb0\u5f55\u4f9b\u5e94\u5546\u521b\u5efa\u7684\u65f6\u95f4\"\n       }\n     ]\n   },\n   {\n     \"name\": \"EZ_Inventory\",\n     \"cn-name\": \"\u5e93\u5b58\u8868\",\n     \"comment\": \"\u5b58\u50a8\u6240\u6709\u5e93\u5b58\u76f8\u5173\u7684\u4fe1\u606f\",\n     \"fields\": [\n       {\n         \"name\": \"inventory_id\",\n         \"cn-name\": \"\u5e93\u5b58ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"true\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u552f\u4e00\u6807\u8bc6\u6bcf\u4e2a\u5e93\u5b58\u9879\u7684ID\"\n       },\n       {\n         \"name\": \"product_id\",\n         \"cn-name\": \"\u4ea7\u54c1ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"true\",\n         \"refer-table\": \"EZ_Product\",\n         \"comment\": \"\u5173\u8054\u5230\u4ea7\u54c1\u8868\u7684\u4ea7\u54c1ID\"\n       },\n       {\n         \"name\": \"quantity\",\n         \"cn-name\": \"\u6570\u91cf\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u5e93\u5b58\u4e2d\u8be5\u4ea7\u54c1\u7684\u6570\u91cf\"\n       },\n       {\n         \"name\": \"create_time\",\n         \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n         \"data-type\": \"datetime\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8bb0\u5f55\u5e93\u5b58\u9879\u521b\u5efa\u7684\u65f6\u95f4\"\n       }\n     ]\n   },\n   {\n     \"name\": \"EZ_PurchaseOrder\",\n     \"cn-name\": \"\u91c7\u8d2d\u8ba2\u5355\u8868\",\n     \"comment\": \"\u5b58\u50a8\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u76f8\u5173\u4fe1\u606f\",\n     \"fields\": [\n       {\n         \"name\": \"order_id\",\n         \"cn-name\": \"\u8ba2\u5355ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"true\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u552f\u4e00\u6807\u8bc6\u6bcf\u4e2a\u91c7\u8d2d\u8ba2\u5355\u7684ID\"\n       },\n       {\n         \"name\": \"supplier_id\",\n         \"cn-name\": \"\u4f9b\u5e94\u5546ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"true\",\n         \"refer-table\": \"EZ_Supplier\",\n         \"comment\": \"\u5173\u8054\u5230\u4f9b\u5e94\u5546\u8868\u7684\u4f9b\u5e94\u5546ID\"\n       },\n       {\n         \"name\": \"total_amount\",\n         \"cn-name\": \"\u603b\u91d1\u989d\",\n         \"data-type\": \"float\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8be5\u91c7\u8d2d\u8ba2\u5355\u7684\u603b\u91d1\u989d\"\n       },\n       {\n         \"name\": \"create_time\",\n         \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n         \"data-type\": \"datetime\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8bb0\u5f55\u91c7\u8d2d\u8ba2\u5355\u521b\u5efa\u7684\u65f6\u95f4\"\n       }\n     ]\n   },\n   {\n     \"name\": \"EZ_PurchaseOrderDetail\",\n     \"cn-name\": \"\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u8868\",\n     \"comment\": \"\u5b58\u50a8\u91c7\u8d2d\u8ba2\u5355\u4e2d\u6bcf\u4e2a\u4ea7\u54c1\u7684\u8be6\u7ec6\u4fe1\u606f\",\n     \"fields\": [\n       {\n         \"name\": \"detail_id\",\n         \"cn-name\": \"\u660e\u7ec6ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"true\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u552f\u4e00\u6807\u8bc6\u6bcf\u4e2a\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u7684ID\"\n       },\n       {\n         \"name\": \"order_id\",\n         \"cn-name\": \"\u8ba2\u5355ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"true\",\n         \"refer-table\": \"EZ_PurchaseOrder\",\n         \"comment\": \"\u5173\u8054\u5230\u91c7\u8d2d\u8ba2\u5355\u8868\u7684\u8ba2\u5355ID\"\n       },\n       {\n         \"name\": \"product_id\",\n         \"cn-name\": \"\u4ea7\u54c1ID\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"true\",\n         \"refer-table\": \"EZ_Product\",\n         \"comment\": \"\u5173\u8054\u5230\u4ea7\u54c1\u8868\u7684\u4ea7\u54c1ID\"\n       },\n       {\n         \"name\": \"quantity\",\n         \"cn-name\": \"\u6570\u91cf\",\n         \"data-type\": \"integer\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8be5\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4e2d\u7684\u4ea7\u54c1\u6570\u91cf\"\n       },\n       {\n         \"name\": \"price\",\n         \"cn-name\": \"\u5355\u4ef7\",\n         \"data-type\": \"float\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8be5\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4e2d\u7684\u4ea7\u54c1\u5355\u4ef7\"\n       },\n       {\n         \"name\": \"create_time\",\n         \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n         \"data-type\": \"datetime\",\n         \"is-pk\": \"false\",\n         \"is-fk\": \"false\",\n         \"refer-table\": \"\",\n         \"comment\": \"\u8bb0\u5f55\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u521b\u5efa\u7684\u65f6\u95f4\"\n       }\n     ]\n   }\n ]\n}\n```\nghhj\nfs";
        List<Map<String, Object>> rtbs = AIHelper.AITableRes2EzJson(res);
        HashMap<String, List<Map<String, Object>>> resMap = new HashMap<String, List<Map<String, Object>>>();
        resMap.put("Tables", rtbs);
        res = JSONObject.toJSONString(resMap);
        System.out.println(res);
    }

    public static void main(String[] args) {
        String res = "{\n  \"fields\": [\n    {\n      \"name\": \"category_id\",\n      \"cn-name\": \"\u4ea7\u54c1\u7c7b\u522bID\",\n      \"data-type\": \"integer\",\n      \"is-pk\": \"no\",\n      \"is-fk\": \"yes\",\n      \"refer-table\": \"categories\",\n      \"comment\": \"\u4ea7\u54c1\u7684\u5206\u7c7bID\uff0c\u5173\u8054\u5230\u5206\u7c7b\u8868\"\n    },\n    {\n      \"name\": \"description\",\n      \"cn-name\": \"\u4ea7\u54c1\u63cf\u8ff0\",\n      \"data-type\": \"string\",\n      \"is-pk\": \"no\",\n      \"is-fk\": \"no\",\n      \"refer-table\": \"\",\n      \"comment\": \"\u5bf9\u4ea7\u54c1\u8fdb\u884c\u8be6\u7ec6\u63cf\u8ff0\"\n    },\n    {\n      \"name\": \"created_at\",\n      \"cn-name\": \"\u521b\u5efa\u65f6\u95f4\",\n      \"data-type\": \"datetime\",\n      \"is-pk\": \"no\",\n      \"is-fk\": \"no\",\n      \"refer-table\": \"\",\n      \"comment\": \"\u8bb0\u5f55\u4ea7\u54c1\u521b\u5efa\u7684\u65f6\u95f4\"\n    }\n  ],\n      \"table-en-name\": \"testout\",\n      \"table-cn-name\": \"\u6d4b\u8bd5\u8f93\u51fa\u8868\",\n}\n";
        List<Map<String, Object>> rfds = AIHelper.AIFieldRes2EzJson(res);
        HashMap<String, List<Map<String, Object>>> resMap = new HashMap<String, List<Map<String, Object>>>();
        resMap.put("Fields", rfds);
        res = JSONObject.toJSONString(resMap);
        System.out.println(res);
    }
}

