/*
 * Decompiled with CFR 0.152.
 */
package com.ezdml.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4638018125560214478L;
    private Set<Entry> entries = null;
    private ArrayList<Entry> list;

    public ArrayMap() {
        this.list = new ArrayList();
    }

    public ArrayMap(Map map) {
        this.list = new ArrayList();
        this.putAll(map);
    }

    public ArrayMap(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Entry>(){

                @Override
                public void clear() {
                    ArrayMap.this.list.clear();
                }

                @Override
                public Iterator<Entry> iterator() {
                    return ArrayMap.this.list.iterator();
                }

                @Override
                public int size() {
                    return ArrayMap.this.list.size();
                }
            };
        }
        return this.entries;
    }

    @Override
    public V put(K key, V value) {
        int i;
        int size = this.list.size();
        Entry entry = null;
        if (key == null) {
            for (i = 0; i < size && (entry = this.list.get(i)).getKey() != null; ++i) {
            }
        } else {
            for (i = 0; i < size && !key.equals((entry = this.list.get(i)).getKey()); ++i) {
            }
        }
        Object oldValue = null;
        if (i < size) {
            oldValue = entry.getValue();
            entry.setValue((Object)value);
        } else {
            this.list.add(new Entry(key, value));
        }
        return (V)oldValue;
    }

    @Override
    public Object clone() {
        return new ArrayMap<K, V>(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Set<Entry> a = this.entries;
        try {
            this.entries = null;
            s.defaultWriteObject();
        }
        finally {
            this.entries = a;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.entries = null;
        s.defaultReadObject();
    }

    static class Entry
    implements Map.Entry<Object, Object>,
    Serializable {
        private static final long serialVersionUID = -5102537653979829284L;
        protected Object key;
        protected Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

