package com.ezdml.erupt.ezdemo;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import xyz.erupt.core.annotation.EruptScan;
import java.lang.Runtime;
import java.lang.System;

@SpringBootApplication
@EntityScan
@EruptScan
public class EzdemoApplication {

    public static void main(String[] args) {

        SpringApplication.run(EzdemoApplication.class, args);

        String portPrefix = "--upcmd=";
        String upcmd=null;
        for (String arg : args) {
            if (arg.startsWith(portPrefix)) {
                upcmd = arg.substring(portPrefix.length());
            }
        }

        try {
            if(upcmd!=null && upcmd.length()>0){
                System.out.println("Running up cmd: "+upcmd);
                Runtime.getRuntime().exec(upcmd);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}
