<%
var parentPkgName=GetGParamValue('EZGEN_ROOT_PKGNAME'); //上级包名
if(!parentPkgName)parentPkgName='com.ruoyi.project';
var modelPkgName=AutoCapProc(curModel.name,'JavaPackageName');
var modelCap=curModel.caption?curModel.caption:curModel.name;
var tb=curTable; //当前表
var tbPkgName=AutoCapProc(tb.name,'JavaPackageName');
var ClsName=AutoCapProc(tb.name,'ClassName'); //类名（驼峰命名，首字母大写）
var instName=AutoCapProc(tb.name,'FieldName'); //类名（驼峰命名，首字母小写）
var dispName=tb.UIDisplayName; //逻辑显示名
if(!dispName)dispName=ClsName;

var fds=tb.metaFields;

var idName='id';
var idTp='Long';
var pk=tb.getPrimaryKeyField();
if(pk){
    idName=AutoCapProc(pk.name,'FieldName');
    if(pk.dataType!='cfdtInteger')
        idTp='String';
}
%>package ${parentPkgName}.${modelPkgName}.${AutoCapProc(tb.name,'JavaPackageName')}.controller;

import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

import ${parentPkgName}.${modelPkgName}.${tbPkgName}.domain.${ClsName};
import ${parentPkgName}.${modelPkgName}.${tbPkgName}.service.I${ClsName}Service;

<%
  //添加外键引用类，并判断主键是否引用了其它表
  var importTbs={};
  //遍历所有字段
  for(var k=0; k<fds.count; k++) 
  { //字段循环开始
    var fd = fds.getItem(k); //取第k个字段
    if(!fd.isPhysicalField()) //判断字段是否物理字段
      continue;
    if(fd.keyFieldType=='cfktId' || fd.keyFieldType=='cfktRid'){ //外键？
      var cf=fd.getRelateTableField(); //外键引用的表字段是否存在
      if(cf){
        var rtb=fd.getRelateTableObj();
        if(rtb.name==tb.name) //引用了自己？
          continue;
        //要在同一个模型才添加引用
        if(!curModel.tables.itemByName(rtb.name, false))
          continue;
        importTbs[rtb.name]=rtb.name;
      }
    }
  }

  //输出所有引入表
  for(var rtbName in importTbs){
    curOut.add('import '+parentPkgName+'.'+modelPkgName+'.'+AutoCapProc(rtbName,'JavaPackageName')+'.service.I'+AutoCapProc(rtbName,'ClassName')+'Service;');
  }
  
%>

/**
 * ${dispName}Controller
 * 
 * @author ezdml
 * Generated by EZDML ${DateTimeToStr(_now())}
 */
@Controller
@RequestMapping("/${modelPkgName}/${tbPkgName}")
public class ${ClsName}Controller extends BaseController
{
    private String prefix = "${modelPkgName}/${tbPkgName}";

    @Autowired
    private I${ClsName}Service ${instName}Service;

<%
  for(var rtbName in importTbs){
    curOut.add('    @Autowired');
    curOut.add('    I'+AutoCapProc(rtbName,'ClassName')+'Service '+AutoCapProc(rtbName,'FieldName')+'Service;'); 
    curOut.add('');
  }
%>

    @RequiresPermissions("${modelPkgName}:${tbPkgName}:view")
    @GetMapping()
    public String ${instName}()
    {
        return prefix + "/${tbPkgName}";
    }

    /**
     * 查询${dispName}列表
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(${ClsName} ${instName})
    {
        startPage();
        List<${ClsName}> list = ${instName}Service.select${ClsName}List(${instName});
        return getDataTable(list);
    }

    /**
     * 导出${dispName}列表
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:export")
    @Log(title = "${dispName}", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(${ClsName} ${instName})
    {
        List<${ClsName}> list = ${instName}Service.select${ClsName}List(${instName});
        ExcelUtil<${ClsName}> util = new ExcelUtil<${ClsName}>(${ClsName}.class);
        return util.exportExcel(list, "${dispName}数据");
    }

    /**
     * 新增${dispName}
     */
    @GetMapping("/add")
    public String add(ModelMap mmap)
    {
<%
  for(var rtbName in importTbs){
    curOut.add('        mmap.put("'+AutoCapProc(rtbName,'FieldName')+'List", '+AutoCapProc(rtbName,'FieldName')+'Service.select'+AutoCapProc(rtbName,'ClassName')+'List(null));');
  }
%>
        return prefix + "/add";
    }

    /**
     * 新增保存${dispName}
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:add")
    @Log(title = "${dispName}", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult addSave(${ClsName} ${instName})
    {
        return toAjax(${instName}Service.insert${ClsName}(${instName}));
    }

    /**
     * 修改${dispName}
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:edit")
    @GetMapping("/edit/{${idName}}")
    public String edit(@PathVariable("${idName}") ${idTp} ${idName}, ModelMap mmap)
    {
        ${ClsName} ${instName} = ${instName}Service.select${ClsName}ById(${idName});
        mmap.put("${instName}", ${instName});
<%
  for(var rtbName in importTbs){
    curOut.add('        mmap.put("'+AutoCapProc(rtbName,'FieldName')+'List", '+AutoCapProc(rtbName,'FieldName')+'Service.select'+AutoCapProc(rtbName,'ClassName')+'List(null));');
  }
%>
        return prefix + "/edit";
    }

    /**
     * 修改保存${dispName}
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:edit")
    @Log(title = "${dispName}", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult editSave(${ClsName} ${instName})
    {
        return toAjax(${instName}Service.update${ClsName}(${instName}));
    }

    /**
     * 删除${dispName}
     */
    @RequiresPermissions("${modelPkgName}:${tbPkgName}:remove")
    @Log(title = "${dispName}", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids)
    {
        return toAjax(${instName}Service.delete${ClsName}ByIds(ids));
    }
}
