<%
/*
Note: The contents of this file will be directly overwritten when EZDML is upgraded. Instead of modifying this file directly, copy the file to a new name and modify the new file.

注意：程序升级时会直接覆盖此文件内容，请不要直接修改此文件，如果需要请将此文件复制到新名称，然后对新文件进行修改。

2025-1-1: 第一版发布

*/

var parentPkgName=GetGParamValue('EZGEN_ROOT_PKGNAME'); //上级包名
if(!parentPkgName)parentPkgName='com.ruoyi.project';

var tb=curTable; //当前表
var ClsName=AutoCapProc(tb.name,'ClassName'); //类名（驼峰命名，首字母大写）
var dispName=tb.UIDisplayName; //逻辑显示名

var fds=tb.metaFields;

%>package ${parentPkgName}.${AutoCapProc(curModel.name,'JavaPackageName')}.${AutoCapProc(tb.name,'JavaPackageName')}.domain;

/*
 * Copyright © ${FormatDateTime('yyyy',_date())} xxx.xx All rights reserved.
 * Author: xxx (xx@xx.com)
 * Generated by EZDML ${DateTimeToStr(_now())}

${tb.describe}

 */

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

${dispName?'/* '+dispName+' */':''}
public class ${ClsName} extends BaseEntity
{
    private static final long serialVersionUID = 1L;

<%
    if(!tb.getPrimaryKeyField()){
      //没有主键的，手工加一个ID
      fout('//注意：本对象没有主键不符合要求，EZDML补了一个ID主键，避免运行出错');
      fout('private long id;');
      fout('');
    }

  //遍历所有字段
  for(var k=0; k<fds.count; k++) 
  { //字段循环开始
    var fd = fds.getItem(k); //取第k个字段
    if(!fd.isPhysicalField()) //判断字段是否物理字段
      continue;

    var fdn=AutoCapProc(fd.name,'FieldName');
    //输出名称
	s = fd.getFieldComments();
	if (s)
	{
      if(s.indexOf("\n")>=0){
        s = replaceAllCRs(s, "     * ");
	    s = '    /**\r\n     * ' + s + '\r\n     */';
      } else {
        s = '    /* '+s+' */';
      }
	  curOut.add(s);
	}
    var expar='';
    if(fd.dataType=='cfdtDate'){
        fout('@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")');
        expar='width = 50, dateFormat = "yyyy-MM-dd HH:mm:ss"';
    }
    if(fd.exportable){
        var mp=fd.displayName;
        if(!mp) mp=fd.labelText;
        if(mp){
            mp='name = "'+mp+'"';
            if(expar) 
                expar=mp+', '+expar;
            else
                expar=mp;
        }
        if(expar)
            expar='('+expar+')';
        fout('@Excel'+expar);
    }

    var tp=getFieldJavaType(fd); //数据类型

    fout('private '+tp+' '+fdn+';');
    fout('');
  } //字段循环结束
  fout('');
  
  //输出getter和setter
  if(!tb.getPrimaryKeyField()){
    wGetSetter('id', 'Long');
  }
  //遍历所有字段
  for(var k=0; k<fds.count; k++) 
  {
    var fd = fds.getItem(k); //取第k个字段
    if(!fd.isPhysicalField()) //判断字段是否物理字段
      continue; 
    var tp=getFieldJavaType(fd); //数据类型
    wGetSetter(fd.name, tp);
  }
  fout('');

  //输出toString
  fout('@Override');
  fout('public String toString() {');
  fout('    return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)');
  if(!tb.getPrimaryKeyField()){
    fout('        .append("id", getId())');
  }
  //遍历所有字段
  for(var k=0; k<fds.count; k++) 
  {
    var fd = fds.getItem(k); //取第k个字段
    if(!fd.isPhysicalField()) //判断字段是否物理字段
      continue;
    var propH=AutoCapProc(fd.name,'ClassName');
    var propL=AutoCapProc(fd.name,'FieldName'); 
    fout('        .append("'+propL+'", get'+propH+'())');
  }
  fout('        .toString();');
  fout('}');

function getFieldJavaType(fd) {
  //获取字段类型对应的JAVA类型
  var cfType=fd.dataType;
  if(cfType.indexOf("cfdt")==0){
    var res= cfType.substr(4);
    if(res=="Integer")
      return "Long";
    if(res=="Float")
      return "Double";
    if(res=="Bool")
      return "Boolean";
    if(res=="Enum")
      return "Integer";
    if(res=="Blob")
      return "byte[]";
    if(res=="List")
      return "List";
    if(res=="Event")
      return "EventClass";
    if(res=="Other")
      return "class";
    return res;
  }
  else
	  return cfType;
}

function fout(s){
  //公共函数：输出行
  curOut.add('    '+s);
}

function replaceAllCRs(s, ns){
    var t=s;
    t = t.replace(/\r\n/g, "\n");
    t = t.replace(/\r/g, "\n");
    t = t.replace(/\n/g, "\n"+ns);
	return t;
}

function wGetSetter(prop, tp){
    var propH=AutoCapProc(prop,'ClassName');
    var propL=AutoCapProc(prop,'FieldName');
%>
    public ${tp} get${propH}() 
    {
        return ${propL};
    }

    public void set${propH}(${tp} ${propL}) 
    {
        this.${propL} = ${propL};
    }
<%
}
%>

}
