/*
 * Decompiled with CFR 0.152.
 */
package com.ezdml.model;

import com.ezdml.model.ArrayMap;
import com.ezdml.model.CtMetaField;
import com.ezdml.model.TypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtMetaTable {
    protected int id;
    protected String name;
    protected String caption;
    protected String memo;
    protected String extraProps;
    protected List<CtMetaField> metaFields = new ArrayList<CtMetaField>();

    public CtMetaTable() {
    }

    public CtMetaTable(Map<String, Object> map) {
        this.loadFromMap(map);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescribe() {
        return this.caption;
    }

    public void setDescribe(String value) {
        this.caption = value;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String value) {
        this.memo = value;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getExtraProps() {
        return this.extraProps;
    }

    public void setExtraProps(String extraProps) {
        this.extraProps = extraProps;
    }

    public List<CtMetaField> getMetaFields() {
        return this.metaFields;
    }

    public CtMetaField newField() {
        CtMetaField res = new CtMetaField();
        this.metaFields.add(res);
        return res;
    }

    public CtMetaField fieldByName(String colName) {
        if (colName == null) {
            return null;
        }
        for (CtMetaField fd : this.metaFields) {
            if (!colName.equalsIgnoreCase(fd.getName())) continue;
            return fd;
        }
        return null;
    }

    public void reset() {
        this.id = 0;
        this.name = null;
        this.caption = null;
        this.memo = null;
        this.metaFields.clear();
    }

    public void assignFrom(CtMetaTable AObj) {
        if (AObj == null) {
            this.reset();
            return;
        }
        this.id = AObj.id;
        this.name = AObj.name;
        this.caption = AObj.caption;
        this.memo = AObj.memo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.metaFields.clear();
        for (int i = 0; i < AObj.metaFields.size(); ++i) {
            map.clear();
            AObj.metaFields.get(i).saveToMap(map);
            this.metaFields.add(new CtMetaField(map));
        }
    }

    public void loadFromMap(Map<String, Object> map) {
        if (map == null) {
            this.reset();
            return;
        }
        this.id = TypeUtil.ObjToInt(map.get("Id"));
        this.name = TypeUtil.ObjToStr(map.get("Name"));
        this.caption = TypeUtil.ObjToStr(map.get("Caption"));
        this.memo = TypeUtil.ObjToStr(map.get("Memo"));
        this.extraProps = TypeUtil.ObjToStr(map.get("ExtraProps"));
        List<Map<String, Object>> fs = TypeUtil.CastToList_SO(map.get("MetaFields"));
        this.metaFields.clear();
        for (int i = 0; i < fs.size(); ++i) {
            this.metaFields.add(new CtMetaField(fs.get(i)));
        }
    }

    public void loadFromAIMap(Map<String, Object> map) {
        if (map == null) {
            this.reset();
            return;
        }
        this.name = TypeUtil.ObjToStr(map.get("name"));
        this.caption = TypeUtil.ObjToStr(map.get("cn-name"));
        this.memo = TypeUtil.ObjToStr(map.get("comment"));
        this.extraProps = TypeUtil.ObjToStr(map.get("referenced-by"));
        List<Map<String, Object>> fs = TypeUtil.CastToList_SO(map.get("fields"));
        this.metaFields.clear();
        for (int i = 0; i < fs.size(); ++i) {
            CtMetaField mf = new CtMetaField();
            mf.setId(i + 1);
            mf.loadFromAIMap(fs.get(i));
            this.metaFields.add(mf);
        }
    }

    public void saveToMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (this.id > 0) {
            map.put("Id", this.id);
        }
        if (this.name != null) {
            map.put("Name", this.name);
        }
        if (this.caption != null) {
            map.put("Caption", this.caption);
        }
        if (this.memo != null) {
            map.put("Memo", this.memo);
        }
        if (this.extraProps != null) {
            map.put("ExtraProps", this.extraProps);
        }
        ArrayList<Map<String, Object>> fs = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.metaFields.size(); ++i) {
            fs.add(this.metaFields.get(i).toMap());
        }
        ArrayMap<String, Serializable> fmap = new ArrayMap<String, Serializable>();
        fmap.put("Count", Integer.valueOf(fs.size()));
        fmap.put("items", fs);
        map.put("MetaFields", fmap);
    }

    public Map<String, Object> toMap() {
        ArrayMap<String, Object> map = new ArrayMap<String, Object>();
        this.saveToMap(map);
        return map;
    }

    public String getPkFieldName() {
        for (CtMetaField mf : this.metaFields) {
            if (mf.keyFieldType != 1) continue;
            return mf.getName();
        }
        return null;
    }
}

