package com.ezdml.codegen.ezdmlcodegendemo;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import java.lang.Runtime;
import java.lang.System;

@EnableSwagger2
@SpringBootApplication
public class EzdmlCodeGenDemoApplication {

    public static void main(String[] args) {

        SpringApplication.run(EzdmlCodeGenDemoApplication.class, args);
        
        String portPrefix = "--upcmd=";
        String upcmd=null;
        for (String arg : args) {
            if (arg.startsWith(portPrefix)) {
                upcmd = arg.substring(portPrefix.length());
            }
        }

        try {
            if(upcmd!=null && upcmd.length()>0){
                System.out.println("Running up cmd: "+upcmd);
                Runtime.getRuntime().exec(upcmd);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

    }

}
