<%
var parentPkgName=GetGParamValue('EZGEN_ROOT_PKGNAME'); //上级包名
if(!parentPkgName)parentPkgName='com.ezdml.codegen.ezdmlcodegendemo';

var tb=curTable; //当前表
var ClsName=AutoCapProc(tb.name,'ClassName'); //类名（驼峰命名，首字母大写）
var tbName=AutoCapProc(tb.name,'FieldName'); //字段名（驼峰命名，首字母小写）
var dispName=tb.UIDisplayName; //逻辑显示名
%>package ${parentPkgName}.${AutoCapProc(curModel.name,'JavaPackageName')}.${AutoCapProc(tb.name,'JavaPackageName')};

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.ArrayList;

@Api(tags = "${dispName} 相关接口")
@RestController
@RequestMapping("/ez_${AutoCapProc(tb.name,'PackageName')}")
public class ${ClsName}Controller {

    @Autowired
    private ${ClsName}Service ${tbName}Service;

    @ApiOperation("获取${dispName}对象列表")
    @GetMapping("/list")
    public List<${ClsName}> list(){
        return ${tbName}Service.findAll();
    }

    @ApiOperation("获取指定ID的${dispName}对象")
    @ApiImplicitParam(name = "id", value = "要获取的${dispName}对象的id" , required = true)
    @GetMapping("/getById")
    public ${ClsName} getById(Long id) {
        return ${tbName}Service.findById(id);
    }

    @ApiOperation("获取总数")
    @GetMapping("/count")
    public long count() {
        return ${tbName}Service.count();
    }

    @ApiOperation("添加新的${dispName}")
    @RequestMapping(value = "/add", method = {RequestMethod.GET,RequestMethod.POST})
    public ${ClsName} add(${ClsName} ${tbName}) {
        return ${tbName}Service.add(${tbName});
    }

    @ApiOperation("修改已有的${dispName}")
    @RequestMapping(value = "/update", method = {RequestMethod.GET,RequestMethod.POST})
    public ${ClsName} update(${ClsName} ${tbName}) {
        return ${tbName}Service.update(${tbName});
    }

    @ApiOperation("删除指定ID的${dispName}对象")
    @ApiImplicitParam(name = "id", value = "要删除的${dispName}对象的id" , required = true)
    @GetMapping("/deleteById")
    public void deleteById(Long id) {
        ${tbName}Service.deleteById(id);
    }

    @ApiOperation("删除指定ID列表的多个${dispName}对象")
    @ApiImplicitParam(name = "ids", value = "要删除的${dispName}对象的id列表" , required = true)
    @RequestMapping(value = "/deleteByIds", method = {RequestMethod.GET,RequestMethod.POST})
    public void deleteByIds(Long[] ids) {
        List<Long> vids=new ArrayList<Long>();
        for(Long id: ids)
            vids.add(id);
        ${tbName}Service.deleteByIds(vids);
    }

}
