/**

 @Name：layuiAdmin 用户管理 管理员管理 角色管理
 @Author：star1029
 @Site：http://www.layui.com/admin/
 @License：LPPL
    
 */


layui.define(['table', 'form'], function(exports){
  var $ = layui.$
  ,table = layui.table
  ,form = layui.form;

  //用户管理
  table.render({
    elem: '#LAY-user-manage'
    //,url: layui.setter.base + 'json/useradmin/webuser.js' //模拟接口
	,data:
	[{
		"id": "001"
		,"username": "用户-1"
		,"avatar": "https://wx4.sinaimg.cn/mw1024/5db11ff4gy1fmx4keaw9pj20dw08caa4.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "002"
		,"username": "用户-2"
		,"avatar": "https://wx4.sinaimg.cn/mw1024/5db11ff4gy1fmx4keaw9pj20dw08caa4.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "003"
		,"username": "用户-3"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "女"
		,"ip": "1111111"
		,"jointime": 20171011
		,"LAY_CHECKED": true
	  },{
		"id": "004"
		,"username": "用户-4"
		,"avatar": "https://wx4.sinaimg.cn/mw1024/5db11ff4gy1fmx4keaw9pj20dw08caa4.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20160505
	  },{
		"id": "005"
		,"username": "用户-5"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
	   "id": "006"
		,"username": "用户-6"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "007"
		,"username": "用户-7"
		,"avatar": "https://wx3.sinaimg.cn/mw690/5db11ff4gy1fmx4keca8ag208g06iglw.gif"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20180210
	  },{
		"id": "008"
		,"username": "用户-8"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "女"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
	   "id": "009"
		,"username": "用户-9"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "女"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "010"
		,"username": "用户-10"
		,"avatar": "https://wx4.sinaimg.cn/mw1024/5db11ff4gy1fmx4keaw9pj20dw08caa4.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20170719
	  },{
		"id": "011"
		,"username": "用户-11"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "012"
		,"username": "用户-12"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "女"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "013"
		,"username": "用户-13"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "女"
		,"ip": "1111111"
		,"jointime": 20171204
		,"LAY_CHECKED": true
	  },{
		"id": "014"
		,"username": "用户-14"
		,"avatar": "https://wx3.sinaimg.cn/mw690/5db11ff4gy1fmx4keca8ag208g06iglw.gif"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  },{
		"id": "015"
		,"username": "用户-15"
		,"avatar": "https://wx2.sinaimg.cn/mw690/5db11ff4gy1fmx4kec5bvj20eb0h3mxh.jpg"
		,"phone": 12345678901
		,"email": "11111@qq.com"
		,"sex": "男"
		,"ip": "1111111"
		,"jointime": 20171204
	  }]
    ,cols: [[
      {type: 'checkbox', fixed: 'left'}
      ,{field: 'id', width: 100, title: 'ID', sort: true}
      ,{field: 'username', title: '用户名', minWidth: 100}
      ,{field: 'avatar', title: '头像', width: 100, templet: '#imgTpl'}
      ,{field: 'phone', title: '手机'}
      ,{field: 'email', title: '邮箱'}
      ,{field: 'sex', width: 80, title: '性别'}
      ,{field: 'ip', title: 'IP'}
      ,{field: 'jointime', title: '加入时间', sort: true}
      ,{title: '操作', width: 150, align:'center', fixed: 'right', toolbar: '#table-useradmin-webuser'}
    ]]
    ,page: true
    ,limit: 30
    ,height: 'full-220'
    ,text: '对不起，加载出现异常！'
  });
  
  //监听工具条
  table.on('tool(LAY-user-manage)', function(obj){
    var data = obj.data;
    if(obj.event === 'del'){
      layer.prompt({
        formType: 1
        ,title: '敏感操作，请验证口令'
      }, function(value, index){
        layer.close(index);
        
        layer.confirm('真的删除行么', function(index){
          obj.del();
          layer.close(index);
        });
      });
    } else if(obj.event === 'edit'){
      var tr = $(obj.tr);

      layer.open({
        type: 2
        ,title: '编辑用户'
        ,content: '../../../views/user/user/userform.html'
        ,maxmin: true
        ,area: ['500px', '450px']
        ,btn: ['确定', '取消']
        ,yes: function(index, layero){
          var iframeWindow = window['layui-layer-iframe'+ index]
          ,submitID = 'LAY-user-front-submit'
          ,submit = layero.find('iframe').contents().find('#'+ submitID);

          //监听提交
          iframeWindow.layui.form.on('submit('+ submitID +')', function(data){
            var field = data.field; //获取提交的字段
            
            //提交 Ajax 成功后，静态更新表格中的数据
            //$.ajax({});
            table.reload('LAY-user-manage'); //数据刷新
            layer.close(index); //关闭弹层
          });  
          
          submit.trigger('click');
        }
        ,success: function(layero, index){
          
        }
      });
    }
  });

  //管理员管理
  table.render({
    elem: '#LAY-user-back-manage'
    //,url: layui.setter.base + 'json/useradmin/mangadmin.js' //模拟接口
	,data:
	[{
		"id": "1001"
		,"loginname": "admin"
		,"telphone": "11111111111"
		,"email": "111@qq.com"
		,"role": "超级管理员"
		,"jointime": "20150217"
		,"check": true
	  },{
		"id": "1002"
		,"loginname": "common-1"
		,"telphone": "22222222222"
		,"email": "222@qq.com"
		,"role": "管理员"
		,"jointime": "20160217"
		,"check": false
	  },{
		"id": "1003"
		,"loginname": "common-2"
		,"telphone": "33333333333"
		,"email": "333@qq.com"
		,"role": "管理员"
		,"jointime": "20161012"
		,"check": false
	  },{
		"id": "1004"
		,"loginname": "common-3"
		,"telphone": "44444444444"
		,"email": "444@qq.com"
		,"role": "管理员"
		,"jointime": "20170518"
		,"check": true
	  },{
		"id": "1005"
		,"loginname": "common-4"
		,"telphone": "55555555555"
		,"email": "555@qq.com"
		,"role": "管理员"
		,"jointime": "20180101"
		,"check": false
	  },{
		"id": "1006"
		,"loginname": "common-5"
		,"telphone": "66666666666"
		,"email": "666@qq.com"
		,"role": "管理员"
		,"jointime": "20160217"
		,"check": false
	  },{
		"id": "1007"
		,"loginname": "common-6"
		,"telphone": "77777777777"
		,"email": "777@qq.com"
		,"role": "管理员"
		,"jointime": "20161012"
		,"check": false
	  },{
		"id": "1008"
		,"loginname": "common-7"
		,"telphone": "88888888888"
		,"email": "888@qq.com"
		,"role": "管理员"
		,"jointime": "20170518"
		,"check": true
	  },{
		"id": "1009"
		,"loginname": "common-8"
		,"telphone": "99999999999"
		,"email": "999@qq.com"
		,"role": "管理员"
		,"jointime": "20180101"
		,"check": false
	}]
    ,cols: [[
      {type: 'checkbox', fixed: 'left'}
      ,{field: 'id', width: 80, title: 'ID', sort: true}
      ,{field: 'loginname', title: '登录名'}
      ,{field: 'telphone', title: '手机'}
      ,{field: 'email', title: '邮箱'}
      ,{field: 'role', title: '角色'}
      ,{field: 'jointime', title: '加入时间', sort: true}
      ,{field: 'check', title:'审核状态', templet: '#buttonTpl', minWidth: 80, align: 'center'}
      ,{title: '操作', width: 150, align: 'center', fixed: 'right', toolbar: '#table-useradmin-admin'}
    ]]
    ,text: '对不起，加载出现异常！'
  });
  
  //监听工具条
  table.on('tool(LAY-user-back-manage)', function(obj){
    var data = obj.data;
    if(obj.event === 'del'){
      layer.prompt({
        formType: 1
        ,title: '敏感操作，请验证口令'
      }, function(value, index){
        layer.close(index);
        layer.confirm('确定删除此管理员？', function(index){
          console.log(obj)
          obj.del();
          layer.close(index);
        });
      });
    }else if(obj.event === 'edit'){
      var tr = $(obj.tr);

      layer.open({
        type: 2
        ,title: '编辑管理员'
        ,content: '../../../views/user/administrators/adminform.html'
        ,area: ['420px', '420px']
        ,btn: ['确定', '取消']
        ,yes: function(index, layero){
          var iframeWindow = window['layui-layer-iframe'+ index]
          ,submitID = 'LAY-user-back-submit'
          ,submit = layero.find('iframe').contents().find('#'+ submitID);

          //监听提交
          iframeWindow.layui.form.on('submit('+ submitID +')', function(data){
            var field = data.field; //获取提交的字段
            
            //提交 Ajax 成功后，静态更新表格中的数据
            //$.ajax({});
            table.reload('LAY-user-front-submit'); //数据刷新
            layer.close(index); //关闭弹层
          });  
          
          submit.trigger('click');
        }
        ,success: function(layero, index){           
          
        }
      })
    }
  });

  //角色管理
  table.render({
    elem: '#LAY-user-back-role'
    //,url: layui.setter.base + 'json/useradmin/role.js' //模拟接口
	,data:
	[{
		"id": "1"
		,"rolename": "超级管理员"
		,"limits": "管理所有的管理员"
		,"descr": "拥有至高无上的权利"
		,"check": true
	  },{
		"id": "2"
		,"rolename": "管理员"
		,"limits": "所有列表的管理"
		,"descr": "事情很多，权力很大"
		,"check": true
	  },{
		"id": "3"
		,"rolename": "文章撰写员"
		,"limits": "负责文章的编写"
		,"descr": "文采第一的人才集合"
		,"check": false
	  },{
		"id": "4"
		,"rolename": "纠错员"
		,"limits": "负责文章内容的修改"
		,"descr": "暂无"
		,"check": false
	  },{
		"id": "5"
		,"rolename": "统计人员"
		,"limits": "对数据进行统计"
		,"descr": "暂无"
		,"check": false
	  },{
		"id": "6"
		,"rolename": "评估员"
		,"limits": "对统计数据进行评估"
		,"descr": "及时捕捉市场发展动态"
		,"check": false
	  },{
		"id": "7"
		,"rolename": "采购员"
		,"limits": "负责员工的伙食"
		,"descr": "暂无"
		,"check": false
	  },{
		"id": "8"
		,"rolename": "推销员"
		,"limits": "介绍销售公司产品"
		,"descr": "暂无"
		,"check": false
	  }]
	,cols: [[
      {type: 'checkbox', fixed: 'left'}
      ,{field: 'id', width: 80, title: 'ID', sort: true}
      ,{field: 'rolename', title: '角色名'}
      ,{field: 'limits', title: '拥有权限'}
      ,{field: 'descr', title: '具体描述'}
      ,{title: '操作', width: 150, align: 'center', fixed: 'right', toolbar: '#table-useradmin-admin'}
    ]]
    ,text: '对不起，加载出现异常！'
  });
  
  //监听工具条
  table.on('tool(LAY-user-back-role)', function(obj){
    var data = obj.data;
    if(obj.event === 'del'){
      layer.confirm('确定删除此角色？', function(index){
        obj.del();
        layer.close(index);
      });
    }else if(obj.event === 'edit'){
      var tr = $(obj.tr);

      layer.open({
        type: 2
        ,title: '编辑角色'
        ,content: '../../../views/user/administrators/roleform.html'
        ,area: ['500px', '480px']
        ,btn: ['确定', '取消']
        ,yes: function(index, layero){
          var iframeWindow = window['layui-layer-iframe'+ index]
          ,submit = layero.find('iframe').contents().find("#LAY-user-role-submit");

          //监听提交
          iframeWindow.layui.form.on('submit(LAY-user-role-submit)', function(data){
            var field = data.field; //获取提交的字段
            
            //提交 Ajax 成功后，静态更新表格中的数据
            //$.ajax({});
            table.reload('LAY-user-back-role'); //数据刷新
            layer.close(index); //关闭弹层
          });  
          
          submit.trigger('click');
        }
        ,success: function(layero, index){
        
        }
      })
    }
  });

  exports('useradmin', {})
});